/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 

/*
 *  SATA Definitions
 *
 */


#define SATA_REGS                  ((SataRegs *)   0x4A140000)


#define DMA_TRANACTION_LENGTH   (0x3)        // 8 DWORDs
#define DMA_BURST_LENGTH        (0x4)        // 8 DWORDs
#define DESIRED_SPEED	0	// No speed negotiation restrictions
//#define DESIRED_SPEED	1	// GEN1 (1.5 Gbps)
//#define DESIRED_SPEED	2	// GEN2 (3 Gbps)



/*---------------------------------------------------------*
 * Register Shift Definitions                              *
 *---------------------------------------------------------*/
// GHC
#define AHCI_GHC_HR_SHIFT   (0)
#define AHCI_GHC_IE_SHIFT   (1)
#define AHCI_GHC_AE_SHIFT   (31)

#define AHCI_GHC_HR         (0x1 << AHCI_GHC_HR_SHIFT) // HBA Reset/Release
#define AHCI_GHC_IE	        (0x1 << AHCI_GHC_IE_SHIFT) // Global Int Enable/Disable
#define AHCI_GHC_AE	        (0x1 << AHCI_GHC_AE_SHIFT) // AHCI/Legacy

// P0CMD
#define	AHCI_PxCMD_ST_SHIFT	   (0)
#define	AHCI_PxCMD_SUD_SHIFT   (1)
#define	AHCI_PxCMD_POD_SHIFT   (2)
#define	AHCI_PxCMD_CLO_SHIFT   (3)
#define	AHCI_PxCMD_FRE_SHIFT   (4)
#define	AHCI_PxCMD_CCS_SHIFT   (8)
#define	AHCI_PxCMD_MPSS_SHIFT  (13)
#define	AHCI_PxCMD_FR_SHIFT    (14)
#define	AHCI_PxCMD_CR_SHIFT    (15)
#define	AHCI_PxCMD_CPS_SHIFT   (16)
#define	AHCI_PxCMD_PMA_SHIFT   (17)
#define	AHCI_PxCMD_HPCP_SHIFT  (18)
#define	AHCI_PxCMD_MPSP_SHIFT  (19)
#define	AHCI_PxCMD_CPD_SHIFT   (20)
#define	AHCI_PxCMD_ESP_SHIFT   (21)
#define	AHCI_PxCMD_ATAPI_SHIFT (24)
#define	AHCI_PxCMD_DLAE_SHIFT  (25)
#define	AHCI_PxCMD_ALPE_SHIFT  (26)
#define	AHCI_PxCMD_ASP_SHIFT   (27)
#define	AHCI_PxCMD_ICC_SHIFT   (28)

/* Port command and status bits */
#define	AHCI_PxCMD_ST	  (0x1 << AHCI_PxCMD_ST_SHIFT)   // Start
#define	AHCI_PxCMD_SUD	  (0x1 << AHCI_PxCMD_SUD_SHIFT)  // Spin-Up Device
#define	AHCI_PxCMD_POD	  (0x1 << AHCI_PxCMD_POD_SHIFT)  // Power On Device
#define	AHCI_PxCMD_CLO	  (0x1 << AHCI_PxCMD_CLO_SHIFT)  // Command List Override
#define	AHCI_PxCMD_FRE	  (0x1 << AHCI_PxCMD_FRE_SHIFT)  // FIS Receive Enable
#define	AHCI_PxCMD_CCS	  (0x1f << AHCI_PxCMD_CCS_SHIFT) // Current Command Slot
#define	AHCI_PxCMD_MPSS	  (0x1 << AHCI_PxCMD_MPSS_SHIFT) // Mechanical Presence Switch State
#define	AHCI_PxCMD_FR	  (0x1 << AHCI_PxCMD_FR_SHIFT)   // FIS Receive Running
#define	AHCI_PxCMD_CR	  (0x1 << AHCI_PxCMD_CR_SHIFT)   // Command List Running
#define	AHCI_PxCMD_CPS	  (0x1 << AHCI_PxCMD_CPS_SHIFT)  // Cold Presence State
#define	AHCI_PxCMD_PMA	  (0x1 << AHCI_PxCMD_PMA_SHIFT)  // Port Multiplier Attached
#define	AHCI_PxCMD_HPCP	  (0x1 << AHCI_PxCMD_HPCP_SHIFT) // Hot Plug Capability
#define	AHCI_PxCMD_MPSP	  (0x1 << AHCI_PxCMD_MPSP_SHIFT) // Mechanical Presence Switch Attached
#define	AHCI_PxCMD_CPD	  (0x1 << AHCI_PxCMD_CPD_SHIFT)  // Cold Presence Detection
#define	AHCI_PxCMD_ESP	  (0x1 << AHCI_PxCMD_ESP_SHIFT)  // External SATA Port
#define	AHCI_PxCMD_ATAPI  (0x1 << AHCI_PxCMD_ATAPI_SHIFT)// Device is ATAPI
#define	AHCI_PxCMD_DLAE	  (0x1 << AHCI_PxCMD_DLAE_SHIFT) // Drive LED on ATAPI Enable
#define	AHCI_PxCMD_ALPE	  (0x1 << AHCI_PxCMD_ALPE_SHIFT) // Aggressive Link Power Management Enable
#define	AHCI_PxCMD_ASP	  (0x1 << AHCI_PxCMD_ASP_SHIFT)  // Aggressive Slumber/Partial.
#define	AHCI_PxCMD_ICC	  (0xf << AHCI_PxCMD_ICC_SHIFT)  // Interface Communication Control.

// P0TFD
#define AHCI_PxTFD_STS_BSY_DRQ_ERR_SHIFT (0) // 
#define AHCI_PxTFD_STS_ERR_SHIFT         (0) // Error during the transfer
#define AHCI_PxTFD_STS_DRQ_SHIFT         (3) // Data transfer is requested
#define AHCI_PxTFD_STS_BSY_SHIFT         (7) // Interface is busy
#define AHCI_PxTFD_ERR_SHIFT             (8) // Latest copy of the task file error register

#define AHCI_PxTFD_STS                   (0xff<< AHCI_PxTFD_STS_SHIFT)
#define AHCI_PxTFD_STS_BSY_DRQ_ERR       (0x88<< AHCI_PxTFD_STS_BSY_DRQ_ERR_SHIFT)
#define AHCI_PxTFD_STS_ERR	             (0x1 << AHCI_PxTFD_STS_ERR_SHIFT)
#define AHCI_PxTFD_STS_DRQ	             (0x1 << AHCI_PxTFD_STS_DRQ_SHIFT)
#define AHCI_PxTFD_STS_BSY	             (0x1 << AHCI_PxTFD_STS_BSY_SHIFT)
#define AHCI_PxTFD_ERR                   (0xff<< AHCI_PxTFD_ERR_SHIFT) 

// P0SCTL and P0SSTS
#define AHCI_PxSCTL_PxSSTS_DET_SHIFT   (0) // Device Detection Initialization
#define AHCI_PxSCTL_PxSSTS_SPD_SHIFT   (4) // Speed
#define AHCI_PxSCTL_PxSSTS_IPM_SHIFT   (8) // Power Management Transitions

#define AHCI_PxSCTL_PxSSTS_DET	       (0xf << AHCI_PxSCTL_PxSSTS_DET_SHIFT)
#define AHCI_PxSCTL_PxSSTS_SPD	       (0xf << AHCI_PxSCTL_PxSSTS_SPD_SHIFT)
#define AHCI_PxSCTL_PxSSTS_IPM	       (0xf << AHCI_PxSCTL_PxSSTS_IPM_SHIFT)

// P0DMACR
#define AHCI_P0DMACR_TXTS_SHIFT      (0) // Transmit Transaction Size
#define AHCI_P0DMACR_RXTS_SHIFT      (4) // Receive Transaction Size
#define AHCI_P0DMACR_TXABL_SHIFT     (8) // Transmit Burst Limit
#define AHCI_P0DMACR_RXABL_SHIFT     (12)// Receive Burst Limit


#define AHCI_P0DMACR_TXTS		     (0xf << AHCI_P0DMACR_TXTS_SHIFT)
#define AHCI_P0DMACR_RXTS 		     (0xf << AHCI_P0DMACR_RXTS_SHIFT)
#define AHCI_P0DMACR_TXABL 		     (0xf << AHCI_P0DMACR_TXABL_SHIFT)
#define AHCI_P0DMACR_RXABL 		     (0xf << AHCI_P0DMACR_RXABL_SHIFT)

// ATA Commands
#define ATA_CMD_READ_SECTOR          (0x20) // PIO Reaad Sector(s) Command
#define ATA_CMD_WRITE_SECTOR         (0x30) // PIO Write Sector(s) Command
#define ATA_CMD_READ_DMA_EXT         (0x25) // Read DMA Ext: Used when using 48-Bit Addressing
#define ATA_CMD_WRITE_DMA_EXT        (0x35) // Write DMA Ext: Used when using 48-Bit Addressing
#define ATA_CMD_READ_DMA             (0xC8) // Read DMA: Used when using 28-Bit Addressing
#define ATA_CMD_WRITE_DMA            (0xCA) // Write DMA: Used when using 28-Bit Addressing
#define ATA_CMD_READ_DMA_QUEUED      (0xC7) // Legacy Queued Read Command (Not to be used by AHCI)
#define ATA_CMD_WRITE_DMA_QUEUED     (0xCC) // Legacy Queued Write Command (Not to be used by AHCI)
#define ATA_CMD_FPDMA_READ           (0x60) // Queued Read Command: First Party DMA Read Cmd
#define ATA_CMD_FPDMA_WRITE          (0x61) // Queued Write Command: First Party DMA Write Cmd
#define ATA_CMD_IDENTIFY_DEVICE      (0xEC) // Receive Device Parameter info using PIO Read Protocol.
#define ATA_CMD_SET_FEATURES		 (0xEF) // Set Feature Command (Used to Disable IORDY)
											//  Invoking this Cmd to ensure proper operation of
											//  SATA Core when invoking Non-Data Command.

// ATA Good Status Signature after Power Up or Port Reset
#define AHCI_P0SIG_SIG_ATA_DEV_GOOD_STAT     (0x00000101) // LBAhigh:LBAmid:LBAlow:SECcnt
#define AHCI_P0SIG_SIG_PACKET_DEV_GOOD_STAT  (0xEB140101) // LBAhigh:LBAmid:LBAlow:SECcnt
#define DEVICE_REG_USE_LBA_ADDRESSING (0x1 << 6)
#define CMDFIS_BYTE1_C_IS_CMD_UPDATE  (0x1 << 7)

/*---------------------------------------------------------*
 * Enumeration Definitions                                 *
 *---------------------------------------------------------*/
typedef enum {
	GLOBALint=0x11,
	PORTint=0x22	// PortInt=LocalInt
}intType;

typedef enum {
	ENABLE=0x33,
	DISABLE=0x55
}intState;

typedef enum {
	INTFIELDS=0x77,
	ERRORFIELDS=0x88
}intOrErrorDiag;

typedef enum {
	DATA_DIR_RD=0xBA,
	DATA_DIR_WR=0xCD
}dataXferDir;

typedef enum {
	PIO_PROTOCOL,
	DMA_PROTOCOL
}xferProtocol;

typedef enum {
	QUEUED_CMD=0xAB,
	NON_QUEUED_CMD=0xDC
}cmdType;

/*---------------------------------------------------------*
 * Structure Definitions                                   *
 *---------------------------------------------------------*/
typedef struct {
	UINT32  capSMPS:1;      // bit[0] // Freon has bonded out an input pin for this purpose. So, set it to 1.
	UINT32  capSSS:1;       // bit[1] // Need to set this to 1 regardless to the support of SSS or not since we are supporting a single HBA port. If using a PM then need to enable this bit one at a time per PM port basis.
	UINT32  piPi:2;         // bits[3:2] // For Freon this should always be set to 1 since bit 0 corresponds to a sigle HBA port support. When using PM, use Command Based switching to access multiple ports.
	UINT32  p0cmdCpd:1;     // bit[4] // We have bonded out the two signals (one input and one output) for Detecting Device that are Bus Powered
	UINT32  p0cmdEsp:1;     // bit[5] // This is most likely needs to be set to Zero since it is mutually exclusive with MPSP.
	UINT32  p0cmdMpsp:1;    // bit[6] // We have bonded out a pin (input) to detect a change on a switch or line
	UINT32  p0cmdHpcp:1;    // bit[7] // Since we support CPD and MPSP by default we will have to support Hot Plugable Capability.
	UINT32  rsv:24;         // bits[24:8] Reserved and populate if need to add more control
}FirmwareCtrlFeatures;

// The following structures are subsets of command FIS that I have interest of and are not here to define the actual Command FIS. See sata_ahci.h for FIS defintion.
typedef struct {
	UINT8 cfisType;
	UINT8 cfisByte1;
	UINT8 cfisCmd;
	UINT8 cfisFeature;
	UINT8 cfisDw1SecNumLbaLow;
	UINT8 cfisDw1CylLowLbaMid;
	UINT8 cfisDw1CylHighLbahigh;
	UINT8 cfisDw1Dev;
	UINT8 cfisDw2SecNumLbaLowExp;
	UINT8 cfisDw2CylLowLbaMidExp;
	UINT8 cfisDw2CylHighLbahighExp;
	UINT8 cfisDw2FeatureExp;
	UINT8 cfisDw3SecCnt;
	UINT8 cfisDw3SecCntExp;
	UINT8 cfisDw3Ctrl;
}cmdFis;

typedef struct  {
    volatile UINT32 CAP;
    volatile UINT32 GHC;
    volatile UINT32 IS;
    volatile UINT32 PI;
    volatile UINT32 VR;
    volatile UINT32 CCCCTL;
    volatile UINT32 CCCPORTS;
    volatile UINT8 RSVD0[132];
    volatile UINT32 BISTAFR;
    volatile UINT32 BISTCR;
    volatile UINT32 BISTFCTR;
    volatile UINT32 BISTSR;
    volatile UINT32 BISTDECR;
    volatile UINT8 RSVD1[44];
    volatile UINT32 TIMER1MS;
    volatile UINT8 RSVD2[4];
    volatile UINT32 GPARAM1R;
    volatile UINT32 GPARAM2R;
    volatile UINT32 PPARAMR;
    volatile UINT32 TESTR;
    volatile UINT32 VERSIONR;
    volatile UINT32 IDR;
    volatile UINT32 P0CLB;
    volatile UINT8 RSVD3[4];
    volatile UINT32 P0FB;
    volatile UINT8 RSVD4[4];
    volatile UINT32 P0IS;
    volatile UINT32 P0IE;
    volatile UINT32 P0CMD;
    volatile UINT8 RSVD5[4];
    volatile UINT32 P0TFD;
    volatile UINT32 P0SIG;
    volatile UINT32 P0SSTS;
    volatile UINT32 P0SCTL;
    volatile UINT32 P0SERR;
    volatile UINT32 P0SACT;
    volatile UINT32 P0CI;
    volatile UINT32 P0SNTF;
    volatile UINT8 RSVD6[48];
    volatile UINT32 P0DMACR;
    volatile UINT8 RSVD7[4];
    volatile UINT32 P0PHYCR;
    volatile UINT32 P0PHYSR;
    volatile UINT32 P1CLB;
    volatile UINT8 RSVD8[4];
    volatile UINT32 P1FB;
    volatile UINT8 RSVD9[4];
	volatile UINT32 P1IS;
	volatile UINT32 P1IE;
	volatile UINT32 P1CMD;
    volatile UINT8 RSVD10[4];
	volatile UINT32 P1TFD;
	volatile UINT32 P1SIG;
	volatile UINT32 P1SSTS;
	volatile UINT32 P1SCTL;
	volatile UINT32 P1SERR;
	volatile UINT32 P1SACT;
	volatile UINT32 P1CI;
	volatile UINT32 P1SNTF;
    volatile UINT8 RSVD11[48];
	volatile UINT32 P1DMACR;
    volatile UINT8 RSVD12[4];
	volatile UINT32 P1PHYCR;
	volatile UINT32 P1PHYSR;
} SataRegs;
extern FirmwareCtrlFeatures swCtrlFeatures;

/*---------------------------------------------------------*
 * Prototypes                                              *
 *---------------------------------------------------------*/
UINT8 chceckSysMemorySize( );
void clearCmdList( );
void clearCmdTables( );
void clearRcvFis( );
void clearDmaBuffers(void);
void invokeHBAReset( );
void performFirmwareInit( );
void cfgDmaSetting( );
void initIntAndClearFlags( );
void performDmaWrite(UINT32 Addr);
void performDmaRead(UINT32 Addr);

void initBaseAddresses( );
void setSataSpeed(UINT8);
void enableRcvFis( );
void enableDisableInt(UINT8,UINT8,UINT32);
void clearIntOrErrorDiag(UINT8,UINT32);
void initMemory(UINT32 *,UINT32,UINT32,UINT32);
char spinUpDeviceAndWaitForInitToComplete(void);
